Unit System35;             {SYSTEM35.PAS, SYSTEM35.TPU}

Interface
Uses DOS, CRT, COM2_96;
var Puffer: Array [0..32767] of Byte;

procedure Port1Aus (Datum: Byte);
procedure Port3Aus (Datum: Byte);
procedure Port4Aus (Datum: Byte);
procedure Port5Aus (Datum: Byte);
function  Port1Ein: Byte;
function  Port3Ein: Byte;
function  Port4Ein: Byte;
function  Port5Ein: Byte;
function  Port6Ein: Byte;
function  Analog8Ein (Kanal: Byte): Byte;
function  Analog10Ein (Kanal: Byte): Integer;
procedure AnalogAus (Kanal, Datum: Byte);
procedure Download (Adresse: Word; Dateiname: String);
procedure ProgrammStart (Adresse: Word);
function  RAMlesen (Adresse: Word): Byte;
procedure RAMschreiben (Adresse: Word; Code: Byte);
procedure RegisterSchreiben (Adresse, Datum: Byte);
function  RegisterLesen (Adresse: Byte): Byte;
procedure SFRschreiben (Adresse, Datum: Byte);
function  SFRlesen (Adresse: Byte): Byte;
procedure DatenLesen (Adresse, Anzahl: Word);
procedure SystemReset;

Implementation

procedure Port1Aus (Datum: Byte);
begin
  sende ($10);
  sende (Datum);
end;

procedure Port3Aus (Datum: Byte);
begin
  sende ($11);
  sende (Datum);
end;

procedure Port4Aus (Datum: Byte);
begin
  sende ($12);
  sende (Datum);
end;

procedure Port5Aus (Datum: Byte);
begin
  sende ($13);
  sende (Datum);
end;

function Port1Ein: Byte;
begin
  sende ($20);
  Port1Ein := Empfang;
end;

function Port3Ein: Byte;
begin
  sende ($21);
  Port3Ein := Empfang;
end;

function Port4Ein: Byte;
begin
  sende ($22);
  Port4Ein := Empfang;
end;

function Port5Ein: Byte;
begin
  sende ($23);
  Port5Ein := Empfang;
end;

function Port6Ein: Byte;
begin
  sende ($24);
  Port6Ein := Empfang;
end;

function Analog8Ein (Kanal: Byte): Byte;
begin
  Sende ($30 + Kanal AND 7);
  Analog8Ein := Empfang;
end;

function Analog10Ein (Kanal: Byte): Integer;
var Highbyte: Byte;
begin
  Sende ($38 + Kanal AND 7);
  Highbyte := Empfang;
  Sende (1);
  Analog10Ein := 256 * Highbyte + Empfang;
end;

procedure AnalogAus (Kanal, Datum: Byte);
begin
  Sende ($40 + Kanal AND 3);
  Sende (Datum);
end;

procedure Download (Adresse: Word; Dateiname: String);
var f: file of Byte;
    r: Integer;
    code, Dummy: Byte;
begin
  Assign (f, Dateiname);
  {$I-} Reset (f); {$I+}
  r := IOResult;
  if r= 0 then begin
    {$I-}
    Sende ($60);
    Sende (hi(Adresse));
    Sende (Lo(Adresse));
    while not EoF(f) do begin
      Dummy := Empfang;
      Sende (1);
      read(f,code);
      Sende(code);
    end;
    Sende (0);
    Close(f);
    {$I+}
  end;
end;

procedure ProgrammStart (Adresse: Word);
begin
  Sende ($61);
  sende (Hi(Adresse));
  Sende (Lo(Adresse));
end;

procedure RAMschreiben (Adresse: Word; Code: Byte);
begin
  Sende ($62);
  Sende (Hi(Adresse));
  Sende (Lo(Adresse));
  Sende (Code);
end;

function RAMlesen (Adresse: Word): Byte;
begin
  Sende ($63);
  Sende (Hi(Adresse));
  Sende (Lo(Adresse));
  RAMlesen := Empfang;
end;

procedure RegisterSchreiben (Adresse, Datum: Byte);
begin
  Sende ($64);
  Sende (Adresse);
  Sende (Datum);
end;

function RegisterLesen (Adresse: Byte): Byte;
begin
  Sende ($65);
  Sende (Adresse);
  RegisterLesen := Empfang;
end;

procedure SFRschreiben (Adresse, Datum: Byte);
begin
  Sende ($66);
  Sende (Adresse);
  Sende (Datum);
end;

function SFRlesen (Adresse: Byte): Byte;
begin
  Sende ($67);
  Sende (Adresse);
  SFRlesen := Empfang;
end;

procedure DatenLesen (Adresse, Anzahl: Word);
var n: Word;
begin
  Sende ($68);
  Sende (hi(Adresse));
  Sende (lo(Adresse));
  for n:= 0 to (Anzahl-1) do begin
    Sende (1);
    Puffer[n] := Empfang;
  end;
  Sende (0);
end;

procedure SystemReset;
begin
  RTS(true);
  delay (200);
  RTS(false);
  Delay (200);
end;

begin
end.
