;UART-Controller 8051       (UART51.ASM)
;11,059MHz, 9600 Baud
#include 8051.H
         .org 0000H

ANFANG   mov   SP,#60H         ;Stackpointer setzten
INIT     clr   TR1             ;Timer 1 stoppen
B1200    mov   TH1,#0D0H       ;Teiler 48, 1200 Baud
         mov   TL1,#0D0H
B9600    jb    P3.2,B19200     ;Jumper 9600?
         mov   TH1,#0FAH       ;Teiler 6, 9600 Baud
         mov   TL1,#0FAH
B19200   jb    P3.3,B57600     ;Jumper 19200?
         mov   TH1,#0FDH       ;Teiler 3, 19200 Baud
         mov   TL1,#0FDH
B57600   jb    P3.4,INIT2      ;Jumper 57600?
         mov   TH1,#0FFH       ;Teiler 1, 57600 Baud
         mov   TL1,#0FFH
INIT2    anl   TMOD,#0FH       ;Timer1: 8-Bit-Auto-Reload
         orl   TMOD,#20H
         setb  TR1             ;Timer Starten
         mov   SCON,#50H       ;InitRS232
         setb  TI
         orl   PCON,#80H       ;SMOD=1

NEXT     acall EMPF
         mov   P2,A            ;Portausgabe Port 2
         clr   P3.5            ;Strobe-Impuls an P3.5
         setb  P3.5 
         Mov   A,P1            ;Portzustand lesen Port 1
         acall SEND
         sjmp  NEXT

EMPF     jnb   RI,EMPF
         mov   A,SBUF
         clr   RI
         ret

SEND     jnb   TI,SEND
         clr   TI
         mov   SBUF,A
         ret
        .end
